# Icinga Knowledge Base - IWKB000010

## Short Message

The Icinga PowerShell Framework is either not installed on the system or not configured properly. Please check https://icinga.com/docs/windows for further details
Error: The term 'Use-Icinga' is not recognized as the name of a cmdlet, function, script file, or operable program. Check the spelling of the name, or if a path was included, verify that the path is correct and try again.

Components:

Module-Path:

C:\windows\ServiceProfiles\NetworkService\Documents\WindowsPowerShell\Modules;C:\Program Files (x86)\WindowsPowerShell\Modules;C:\windows\system32\WindowsPowerShell\v1.0\Modules

## Reason

The Icinga PowerShell Framework is either not installed on the system, the service user running the Icinga Agent is unable to access the PowerShell module folder it is installed into or you have installed the wrong architecture of the Icinga Agent.

## Solution

### Test Installation

First check locally if Icinga for Windows is installed properly. You can do so by opening a PowerShell and type `icinga` into the prompt. If you are greeted with an Icinga shell, the installation is working properly.

In case this fails, ensure you are running the correct PowerShell on your system.

For `x86` systems, there is only one PowerShell present.

For `x64` systems (the majority), you will have to open the `Windows PowerShell`, **NOT** the `Windows PowerShell (x86)`.

If you have ensured the correct PowerShell is started, try again with the `icinga` command

### Check PowerShell Module Folders

Ensure that the folder you have installed the Icinga PowerShell Framework into is listed at `$Env:PSModulePath`. The above error message also provides a list of module folders which are checked by the service user. Ensure the module folder you have installed everything into is listed there.
If it is not present, either move the Icinga for Windows files to a listed folder or add it to the environment variables.

If you installed Icinga for Windows into `C:\Program Files\WindowsPowerShell\Modules` and it is not listed in aboves messages, please read on.

### Wrong Agent Architecture

In case you receive above error while installing Icinga for Windows into `C:\Program Files\WindowsPowerShell\Modules`, it means you have installed the `x86` version of the Icinga Agent instead of the `x64` version.
This mostly happens when you start the wrong PowerShell architecture (see `Test Installation` above) and install Icinga for Windows from this shell. If you started an `x86` shell on an `x64` system, the Icinga for Windows installer will install the `x86` Icinga Agent, which then have no access to the `x64` files, causing the above error.

To resolve this, open the correct PowerShell and run the following command:

```powershell
Install-IcingaComponent -Name agent -Force -Confirm;
```

This will uninstall the wrong `x86` and install the correct `x64` version of the Icinga Agent.

If you receive an error `[SC] ChangeServiceConfig FAILED 1072: The specified service has been marked for deletion` error, please have a look on the next [Knowledge Base entry IWKB000011](IWKB000011.md)
