<?php

namespace Icinga\Module\Vspheredb\MappedClass;

/**
 * Specification for an individual physical NIC
 */
#[\AllowDynamicProperties]
class DistributedVirtualSwitchHostMemberPnicSpec
{
    /**
     * Cookie that represents this DistributedVirtualSwitchPortConnection
     * instance for the port. The cookie value is generated by the Server. The
     * Server ignores any value set by an SDK client.
     *
     * The same cookie is present in the distributed virtual port configuration
     * (DistributedVirtualPort.connectionCookie) so that the Server can verify
     * that the entity is the rightful connectee of the port.
     *
     * @var int
     */
    public $connectionCookie;

    /**
     * Name of the physical NIC to be added to the proxy switch
     *
     * See PhysicalNic.device
     *
     * @var string
     */
    public $pnicDevice;

    /**
     * Key of the portgroup to be connected to the physical NIC
     *
     * @var string
     */
    public $uplinkPortgroupKey;

    /**
     * Key of the port to be connected to the physical NIC
     *
     * @var string
     */
    public $uplinkPortKey;
}
